/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.ContainerEnder;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.gui.IoConfigRenderer;
import crazypants.enderio.base.gui.RedstoneModeButton;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.machine.baselegacy.AbstractInventoryMachineEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.gui.GuiButtonIoConfig;
import crazypants.enderio.base.machine.gui.GuiOverlayIoConfig;
import crazypants.enderio.base.machine.interfaces.IIoConfigurable;
import crazypants.enderio.base.machine.modes.IoMode;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.tileentity.TileEntity;

public abstract class GuiMachineBase<T extends AbstractInventoryMachineEntity>
extends GuiContainerBaseEIO<T> {
    @Nonnull
    public static final Vector4f PUSH_COLOR = new Vector4f(0.8f, 0.4f, 0.1f, 0.5f);
    @Nonnull
    public static final Vector4f PULL_COLOR = new Vector4f(0.1f, 0.4f, 0.8f, 0.5f);
    public static final int BUTTON_SIZE = 16;
    private static final int CONFIG_ID = 8962349;
    private static final int RECIPE_ID = 8962350;
    @Nonnull
    protected RedstoneModeButton<T> redstoneButton;
    @Nonnull
    private final GuiOverlayIoConfig<T> configOverlay;
    @Nonnull
    protected final GuiButtonIoConfig<T> configB;
    @Nonnull
    protected IconButton recipeButton;
    protected List<GuiToolTip> progressTooltips;
    protected int lastProgressTooltipValue = -1;

    protected GuiMachineBase(@Nonnull T machine, @Nonnull Container par1Container, String ... guiTexture) {
        super(machine, par1Container, guiTexture);
        this.field_146999_f = this.getXSize();
        this.field_147000_g = this.getYSize();
        int x = this.getButtonXPos() - 5 - 16;
        int y = 5;
        this.redstoneButton = new RedstoneModeButton<TileEntity>((IGuiScreen)this, -1, x, y, (TileEntity)this.getOwner());
        this.configOverlay = new GuiOverlayIoConfig((IIoConfigurable)machine);
        this.addOverlay(this.configOverlay);
        this.configB = new GuiButtonIoConfig<T>((IGuiScreen)this, 8962349, x, y += 19, machine, this.configOverlay);
        y += 19;
        if (((Boolean)PersonalConfig.recipeButtonInMachineGuis.get()).booleanValue()) {
            this.recipeButton = new IconButton((IGuiScreen)this, 8962350, x, y, (IWidgetIcon)IconEIO.RECIPE_BOOK);
            this.recipeButton.setIsVisible(false);
        } else {
            this.recipeButton = new IconButton((IGuiScreen)this, 8962350, x, y, (IWidgetIcon)IconEIO.RECIPE);
            this.recipeButton.setIsVisible(false);
            this.recipeButton.setIconMargin(1, 1);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.redstoneButton.onGuiInit();
        this.configB.onGuiInit();
        this.recipeButton.onGuiInit();
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(i);
            guibutton.func_191745_a(this.field_146297_k, 0, 0, 0.0f);
        }
        if (this.showRecipeButton()) {
            this.recipeButton.setIsVisible(true);
        }
        super.func_146976_a(par1, par2, par3);
        this.renderSlotHighlights();
    }

    public void renderSlotHighlights() {
        IoConfigRenderer.SelectedFace<T> sel = this.configOverlay.getSelection();
        if (sel != null) {
            IoMode mode = ((AbstractInventoryMachineEntity)sel.config).getIoMode(sel.face);
            this.renderSlotHighlights(mode);
        }
    }

    public void renderSlotHighlights(@Nonnull IoMode mode) {
        SlotDefinition slotDef = ((AbstractInventoryMachineEntity)this.getTileEntity()).getSlotDefinition();
        for (Slot invSlot : this.field_147002_h.field_75151_b) {
            if (invSlot.field_75224_c != this.getTileEntity() && (!(this.field_147002_h instanceof ContainerEnder) || invSlot.field_75224_c != ((ContainerEnder)this.field_147002_h).getInv())) continue;
            if ((mode == IoMode.PULL || mode == IoMode.PUSH_PULL) && slotDef.isInputSlot(invSlot.getSlotIndex())) {
                this.renderSlotHighlight(invSlot, PULL_COLOR);
                continue;
            }
            if (mode != IoMode.PUSH && mode != IoMode.PUSH_PULL || !slotDef.isOutputSlot(invSlot.getSlotIndex())) continue;
            this.renderSlotHighlight(invSlot, PUSH_COLOR);
        }
    }

    protected void renderSlotHighlight(int slot, @Nonnull Vector4f col) {
        Slot invSlot = (Slot)this.field_147002_h.field_75151_b.get(slot);
        this.renderSlotHighlight(col, invSlot.field_75223_e, invSlot.field_75221_f, 16, 16);
    }

    protected void renderSlotHighlight(@Nonnull Slot invSlot, @Nonnull Vector4f col) {
        this.renderSlotHighlight(col, invSlot.field_75223_e, invSlot.field_75221_f, 16, 16);
    }

    protected void renderSlotHighlight(@Nonnull Vector4f col, int x, int y, int widthIn, int heightIn) {
        GlStateManager.func_179147_l();
        RenderUtil.renderQuad2D((double)(this.getGuiLeft() + x), (double)(this.getGuiTop() + y), (double)0.0, (double)widthIn, (double)heightIn, (Vector4f)col);
        GlStateManager.func_179084_k();
    }

    protected boolean isConfigOverlayEnabled() {
        return this.configOverlay.isVisible();
    }

    @Nonnull
    protected T getTileEntity() {
        return (T)((AbstractInventoryMachineEntity)this.getOwner());
    }

    protected void addProgressTooltip(int x, int y, int w, int h) {
        if (this.progressTooltips == null) {
            this.progressTooltips = new ArrayList<GuiToolTip>();
        }
        GuiToolTip tt = new GuiToolTip(new Rectangle(x, y, w, h), (String[])null);
        this.progressTooltips.add(tt);
        this.addToolTip(tt);
    }

    protected final void updateProgressTooltips(int scaledProgress, float progress) {
        if (this.lastProgressTooltipValue == scaledProgress || this.progressTooltips == null) {
            return;
        }
        this.lastProgressTooltipValue = scaledProgress;
        if (scaledProgress < 0) {
            for (GuiToolTip tt : this.progressTooltips) {
                tt.setIsVisible(false);
            }
            return;
        }
        String msg = this.formatProgressTooltip(scaledProgress, progress);
        String[] tooltip = msg.split("\\|");
        for (GuiToolTip tt : this.progressTooltips) {
            tt.setToolTipText(tooltip);
            tt.setIsVisible(true);
        }
    }

    protected String formatProgressTooltip(int scaledProgress, float progress) {
        return Lang.GUI_GENERIC_PROGRESS.get(scaledProgress);
    }

    protected int scaleProgressForTooltip(float progress) {
        return (int)(progress * 100.0f);
    }

    protected boolean shouldRenderProgress() {
        if (this.getTileEntity() instanceof IProgressTile) {
            float progress = ((IProgressTile)this.getTileEntity()).getProgress();
            if (progress >= 0.0f && progress <= 1.0f) {
                this.updateProgressTooltips(this.scaleProgressForTooltip(progress), progress);
                return true;
            }
            this.updateProgressTooltips(-1, -1.0f);
            return false;
        }
        return false;
    }

    protected int getProgressScaled(int scale) {
        if (this.getTileEntity() instanceof IProgressTile) {
            return Util.getProgressScaled((int)scale, (IProgressTile)((IProgressTile)this.getTileEntity()));
        }
        return 0;
    }

    protected int getButtonXPos() {
        return this.getXSize();
    }
}

