/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.function.BooleanSupplier;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;

public abstract class AbstractForgeConfigConditionalFactory
implements IConditionFactory {
    private Configuration config;

    protected AbstractForgeConfigConditionalFactory(Configuration config) {
        this.config = config;
    }

    public BooleanSupplier parse(JsonContext context, JsonObject json) {
        String category = JsonUtils.func_151200_h((JsonObject)json, (String)"category");
        String key = JsonUtils.func_151200_h((JsonObject)json, (String)"key");
        boolean flip = JsonUtils.func_151209_a((JsonObject)json, (String)"flip", (boolean)false);
        if (this.config.hasCategory(category)) {
            ConfigCategory cat = this.config.getCategory(category);
            if (cat.containsKey(key) && cat.get(key).isBooleanValue()) {
                return () -> flip != cat.get(key).getBoolean();
            }
            throw new JsonParseException(String.format("Key doesn't exist on category or is not of a boolean type. Category: %s, Key: %s", category, key));
        }
        throw new JsonParseException(String.format("Category doesn't exist on config file. Category: %s, Config: %s", category, this.config.getConfigFile().getAbsolutePath()));
    }
}

