/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.customRecipes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipesCovalenceRepair
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private Tuple<ItemStack, List<ItemStack>> findIngredients(InventoryCrafting inv) {
        ArrayList<ItemStack> dust = new ArrayList<ItemStack>();
        ItemStack tool = ItemStack.field_190927_a;
        boolean foundItem = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack input = inv.func_70301_a(i);
            if (input.func_190926_b()) continue;
            if (ItemHelper.isItemRepairable(input)) {
                if (!foundItem) {
                    tool = input;
                    foundItem = true;
                    continue;
                }
                return new Tuple((Object)ItemStack.field_190927_a, Collections.emptyList());
            }
            if (input.func_77973_b() == ObjHandler.covalence) {
                dust.add(input);
                continue;
            }
            return new Tuple((Object)ItemStack.field_190927_a, Collections.emptyList());
        }
        return new Tuple((Object)tool, dust);
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        Tuple<ItemStack, List<ItemStack>> ingredients = this.findIngredients(inv);
        if (((ItemStack)ingredients.func_76341_a()).func_190926_b() || ((List)ingredients.func_76340_b()).isEmpty()) {
            return false;
        }
        long emcPerDurability = EMCHelper.getEMCPerDurability((ItemStack)ingredients.func_76341_a());
        long dustEmc = 0L;
        for (ItemStack stack : (List)ingredients.func_76340_b()) {
            dustEmc += EMCHelper.getEmcValue(stack);
        }
        return dustEmc >= emcPerDurability;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        Tuple<ItemStack, List<ItemStack>> ingredients = this.findIngredients(inv);
        long emcPerDurability = EMCHelper.getEMCPerDurability((ItemStack)ingredients.func_76341_a());
        long dustEmc = 0L;
        for (ItemStack stack : (List)ingredients.func_76340_b()) {
            dustEmc += EMCHelper.getEmcValue(stack);
        }
        ItemStack output = ((ItemStack)ingredients.func_76341_a()).func_77946_l();
        output.func_77964_b((int)Math.max((long)output.func_77952_i() - dustEmc / emcPerDurability, 0L));
        return output;
    }

    public boolean func_194133_a(int width, int height) {
        return width > 1 || height > 1;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }
}

