/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.impl;

import com.google.common.collect.ImmutableTable;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import org.embeddedt.vintagefix.classloading.FastImmutableMapDefiner;
import org.embeddedt.vintagefix.ducks.FastMapStateHolder;
import org.embeddedt.vintagefix.fastmap.FastMap;

public class StateHolderImpl {
    public static final ThreadLocal<Map<Map<IProperty<?>, Comparable<?>>, ?>> LAST_STATE_MAP = new ThreadLocal();
    public static final ThreadLocal<FastMap<?>> LAST_FAST_STATE_MAP = new ThreadLocal();

    public static <S> void populateNeighbors(Map<Map<IProperty<?>, Comparable<?>>, S> states, FastMapStateHolder<S> holder) {
        if (states.size() == 1) {
            holder.setNeighborTable(ImmutableTable.of());
            return;
        }
        if (holder.getNeighborTable() != null) {
            throw new IllegalStateException();
        }
        if (states == LAST_STATE_MAP.get()) {
            holder.setStateMap(LAST_FAST_STATE_MAP.get());
        } else {
            LAST_STATE_MAP.set(states);
            FastMap<S> globalTable = new FastMap<S>((Collection<IProperty<?>>)holder.getVanillaPropertyMap().keySet(), states, false);
            holder.setStateMap(globalTable);
            LAST_FAST_STATE_MAP.set(globalTable);
        }
        int index = holder.getStateMap().getIndexOf((Map<IProperty<?>, Comparable<?>>)holder.getVanillaPropertyMap());
        holder.setStateIndex(index);
        holder.replacePropertyMap(FastImmutableMapDefiner.makeMap(holder));
        holder.setNeighborTable(null);
    }
}

