/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.recipes.ingredients;

import com.animania.common.handler.AddonHandler;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class AddonItemIngredient
extends Ingredient {
    private Ingredient main;
    private Ingredient fallback;
    private String addonID;

    public AddonItemIngredient(Ingredient main, Ingredient fallback, String addonId) {
        super(AddonHandler.isAddonLoaded(addonId) ? main.func_193365_a() : fallback.func_193365_a());
        this.main = main;
        this.fallback = fallback;
        this.addonID = addonId;
    }

    public static class Factory
    implements IIngredientFactory {
        public Ingredient parse(JsonContext context, JsonObject json) {
            String id = json.get("addon").getAsString();
            Ingredient main = null;
            if (AddonHandler.isAddonLoaded(id)) {
                main = CraftingHelper.getIngredient((JsonElement)json.get("item"), (JsonContext)context);
            }
            Ingredient fallback = CraftingHelper.getIngredient((JsonElement)json.get("fallback"), (JsonContext)context);
            AddonItemIngredient ing = new AddonItemIngredient(main, fallback, id);
            return ing;
        }
    }
}

