/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.generic.ai;

import com.animania.api.interfaces.ISleeping;
import com.animania.common.blocks.BlockSaltLick;
import com.animania.common.entities.generic.ai.GenericAISearchBlock;
import com.animania.common.handler.AddonInjectionHandler;
import com.animania.common.handler.BlockHandler;
import com.animania.config.AnimaniaConfig;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GenericAIFindSaltLick<T extends EntityCreature>
extends GenericAISearchBlock {
    private final T entity;
    private final double speed;
    private EntityAIBase eatAI;
    private int delay;

    public GenericAIFindSaltLick(T creature, double speedIn, @Nullable EntityAIBase eatAI) {
        super((EntityCreature)creature, speedIn, AnimaniaConfig.gameRules.aiBlockSearchRange, EnumFacing.field_176754_o);
        this.entity = creature;
        this.speed = speedIn;
        this.func_75248_a(3);
        this.eatAI = eatAI;
        this.delay = 0;
    }

    @Override
    public boolean func_75250_a() {
        if (++this.delay <= AnimaniaConfig.careAndFeeding.saltLickTick) {
            return false;
        }
        if (this.entity.func_110143_aJ() >= this.entity.func_110138_aP() || this.entity.func_184207_aI() || ((ISleeping)this.entity).getSleeping() || AddonInjectionHandler.runInjection("farm", "pigMudTest", Boolean.class, this.entity).booleanValue()) {
            this.delay = 0;
            return false;
        }
        if (this.entity.func_70681_au().nextInt(3) != 0) {
            return false;
        }
        this.delay = 0;
        return super.func_75250_a();
    }

    @Override
    public void func_75246_d() {
        IBlockState state;
        Block block;
        super.func_75246_d();
        if (this.isAtDestination() && (block = (state = this.world.func_180495_p(this.seekingBlockPos)).func_177230_c()) == BlockHandler.blockSaltLick) {
            if (this.eatAI != null) {
                this.eatAI.func_75249_e();
            }
            BlockSaltLick salt = (BlockSaltLick)block;
            salt.useSaltLick(this.world, this.seekingBlockPos, (EntityLivingBase)this.entity);
            this.delay = 0;
        }
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.entity.func_110143_aJ() < this.entity.func_110138_aP();
    }

    @Override
    protected boolean shouldMoveTo(World worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return block == BlockHandler.blockSaltLick;
    }
}

