/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.misc;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.EXTSeparateShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;
import xaero.map.WorldMap;
import xaero.map.gui.IScreenBase;
import xaero.map.mods.SupportMods;

public class Misc {
    private static final long[] ZERO_LONG_586 = new long[586];
    private static long cpuTimerPreTime;
    private static long glTimerPreTime;
    public static final String OUTDATED_FILE_EXT = ".outdated";
    private static int shadersType;
    private static boolean EXTgeometryShader;

    public static int myFloor(double d) {
        int asInt = (int)d;
        if ((double)asInt != d && d < 0.0) {
            --asInt;
        }
        return asInt;
    }

    public static double round(double a, int komaarvu) {
        double x = Math.pow(10.0, komaarvu);
        return (double)Math.round(a * x) / x;
    }

    public static IBlockState getStateById(int id) {
        try {
            return Block.func_176220_d((int)id);
        }
        catch (Exception e) {
            return Misc.getDefaultBlockStateForStateId(id);
        }
    }

    private static IBlockState getDefaultBlockStateForStateId(int id) {
        try {
            Block block = Block.func_176220_d((int)id).func_177230_c();
            return block.func_176223_P();
        }
        catch (Exception e) {
            return Blocks.field_150350_a.func_176223_P();
        }
    }

    public static void glTimerPre() {
        GL11.glFinish();
        glTimerPreTime = System.nanoTime();
    }

    public static int glTimerResult() {
        GL11.glFinish();
        return (int)(System.nanoTime() - glTimerPreTime);
    }

    public static void timerPre() {
        cpuTimerPreTime = System.nanoTime();
    }

    public static int timerResult() {
        return (int)(System.nanoTime() - cpuTimerPreTime);
    }

    public static double getMouseX(Minecraft mc) {
        return Mouse.getX();
    }

    public static double getMouseY(Minecraft mc) {
        return mc.field_71440_d - Mouse.getY() - 1;
    }

    public static void clearHeightsData586(long[] data) {
        System.arraycopy(ZERO_LONG_586, 0, data, 0, 586);
    }

    public static <T extends Comparable<? super T>> void addToListOfSmallest(int maxSize, List<T> list, T element) {
        int currentSize = list.size();
        if (currentSize == maxSize && ((Comparable)list.get(currentSize - 1)).compareTo(element) <= 0) {
            return;
        }
        int iterLimit = currentSize == maxSize ? maxSize : currentSize + 1;
        for (int i = 0; i < iterLimit; ++i) {
            if (i != currentSize && element.compareTo(list.get(i)) >= 0) continue;
            list.add(i, element);
            if (currentSize != maxSize) break;
            list.remove(currentSize);
            break;
        }
    }

    public static void minecraftOrtho(ScaledResolution scaledresolution) {
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
    }

    public static void setShaderProgram(int program) {
        if (shadersType == -500) {
            shadersType = GLContext.getCapabilities().OpenGL20 ? 0 : (GLContext.getCapabilities().GL_ARB_shader_objects ? 1 : (GLContext.getCapabilities().GL_EXT_separate_shader_objects ? 2 : -1));
            EXTgeometryShader = GLContext.getCapabilities().GL_EXT_geometry_shader4 || GLContext.getCapabilities().GL_ARB_geometry_shader4;
        }
        switch (shadersType) {
            case 0: {
                GL20.glUseProgram((int)program);
                break;
            }
            case 1: {
                ARBShaderObjects.glUseProgramObjectARB((int)program);
                break;
            }
            case 2: {
                EXTSeparateShaderObjects.glUseShaderProgramEXT((int)35633, (int)program);
                if (EXTgeometryShader) {
                    EXTSeparateShaderObjects.glUseShaderProgramEXT((int)36313, (int)program);
                }
                EXTSeparateShaderObjects.glUseShaderProgramEXT((int)35632, (int)program);
                EXTSeparateShaderObjects.glActiveProgramEXT((int)program);
                break;
            }
        }
    }

    public static String getKeyName(KeyBinding kb) {
        if (kb == null || kb.func_151463_i() == 0) {
            return "(unset)";
        }
        return kb.getDisplayName().toUpperCase();
    }

    public static boolean inputMatchesKeyBinding(boolean mouse, int code, KeyBinding kb, IKeyConflictContext conflictContext) {
        if (code == 0) {
            return false;
        }
        if (mouse) {
            code -= 100;
        }
        return kb != null && kb.func_151463_i() == code && kb.getKeyModifier().isActive(conflictContext);
    }

    public static Path quickFileBackupMove(Path file) throws IOException {
        Path backupPath = null;
        int backupNumber = 0;
        while (Files.exists(backupPath = file.resolveSibling(file.getFileName().toString() + ".backup" + backupNumber), new LinkOption[0])) {
            ++backupNumber;
        }
        Files.move(file, backupPath, new CopyOption[0]);
        return backupPath;
    }

    public static void safeMoveAndReplace(Path from, Path to, boolean backupFrom) throws IOException {
        Path fromBackupPath;
        Path backupPath;
        block8: {
            backupPath = null;
            fromBackupPath = null;
            if (backupFrom) {
                while (true) {
                    try {
                        fromBackupPath = Misc.quickFileBackupMove(from);
                        break block8;
                    }
                    catch (IOException ioe2) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
            fromBackupPath = from;
        }
        if (Files.exists(to, new LinkOption[0])) {
            backupPath = Misc.quickFileBackupMove(to);
        }
        Files.move(fromBackupPath, to, new CopyOption[0]);
        if (backupPath != null) {
            Files.delete(backupPath);
        }
    }

    public static void deleteFile(Path file, int attempts) throws IOException {
        --attempts;
        try {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                    if (iOException != null) {
                        throw iOException;
                    }
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            if (attempts > 0) {
                WorldMap.LOGGER.info("Failed to delete file/folder! Retrying... " + attempts);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Misc.deleteFile(file, attempts);
            }
            throw e;
        }
    }

    public static Path convertToOutdated(Path path, int attempts) throws IOException {
        if (path.getFileName().toString().endsWith(OUTDATED_FILE_EXT)) {
            return path;
        }
        Path outdatedPath = path.resolveSibling(path.getFileName().toString() + OUTDATED_FILE_EXT);
        if (Files.exists(path, new LinkOption[0])) {
            Misc.convertToOutdated(path, outdatedPath, attempts);
        }
        return outdatedPath;
    }

    private static void convertToOutdated(Path path, Path outdatedPath, int attempts) throws IOException {
        --attempts;
        try {
            Files.move(path, outdatedPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            if (attempts > 0) {
                WorldMap.LOGGER.info("Failed to convert file to outdated! Retrying... " + attempts);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Misc.convertToOutdated(path, outdatedPath, attempts);
            }
            throw e;
        }
    }

    public static boolean screenShouldSkipWorldRender(GuiScreen screen, boolean checkOtherMod) {
        return screen instanceof IScreenBase && ((IScreenBase)screen).shouldSkipWorldRender() || checkOtherMod && SupportMods.minimap() && SupportMods.xaeroMinimap.screenShouldSkipWorldRender(screen);
    }

    public static boolean hasItem(EntityPlayer player, Item item) {
        return Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_184439_c, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_70460_b, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, 9, item);
    }

    public static boolean hasItem(NonNullList<ItemStack> inventory, int limit, Item item) {
        for (int i = 0; i < inventory.size() && (limit == -1 || i < limit); ++i) {
            if (inventory.get(i) == null || ((ItemStack)inventory.get(i)).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    private static <T> Field getForgeMappedField(Class<T> clazz, String name) throws ReflectionHelper.UnableToFindFieldException {
        return ObfuscationReflectionHelper.findField(clazz, (String)name);
    }

    private static Method getForgeMappedMethod(Class<?> clazz, String name, Class<?> returnType, Class<?> ... parameterTypes) throws ReflectionHelper.UnableToFindMethodException {
        return ObfuscationReflectionHelper.findMethod(clazz, (String)name, returnType, (Class[])parameterTypes);
    }

    public static Class<?> getClassForName(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    public static Field getFieldReflection(Class<?> c, String obfuscatedName) {
        Field field = null;
        try {
            field = Misc.getForgeMappedField(c, obfuscatedName);
        }
        catch (ReflectionHelper.UnableToFindFieldException e) {
            throw new RuntimeException(e);
        }
        return field;
    }

    public static <A, B> B getReflectFieldValue(A parentObject, Field field) {
        boolean accessibleBU = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(parentObject);
        }
        catch (Exception e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        field.setAccessible(accessibleBU);
        return (B)result;
    }

    public static <A, B> void setReflectFieldValue(A parentObject, Field field, B value) {
        boolean accessibleBU = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(parentObject, value);
        }
        catch (Exception e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        field.setAccessible(accessibleBU);
    }

    public static Method getMethodReflection(Class<?> c, String obfuscatedName, Class<?> returnType, Class<?> ... parameters) {
        Method method = null;
        try {
            method = Misc.getForgeMappedMethod(c, obfuscatedName, returnType, parameters);
        }
        catch (ReflectionHelper.UnableToFindMethodException e) {
            throw new RuntimeException(e);
        }
        return method;
    }

    public static <A, B> B getReflectMethodValue(A parentObject, Method method, Object ... arguments) {
        boolean accessibleBU = method.isAccessible();
        method.setAccessible(true);
        Object result = null;
        try {
            result = method.invoke(parentObject, arguments);
        }
        catch (Exception e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        method.setAccessible(accessibleBU);
        return (B)result;
    }

    public static int getTeamColour(Entity e) {
        Integer teamColour = null;
        Team team = e.func_96124_cp();
        if (team != null) {
            String prefix = team.func_178775_l().toString();
            try {
                teamColour = Minecraft.func_71410_x().field_71466_p.func_175064_b(prefix.charAt(prefix.length() - 1));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return teamColour == null ? -1 : teamColour;
    }

    public static void setFieldText(GuiTextField field, String text) {
        Misc.setFieldText(field, text, -1);
    }

    public static void setFieldText(GuiTextField field, String text, int color) {
        field.func_146193_g(color);
        if (field.func_146179_b().equals(text)) {
            return;
        }
        field.func_146180_a(text);
    }

    static {
        shadersType = -500;
    }
}

