/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.ModOptionSlider;
import xaero.map.gui.TooltipButton;
import xaero.map.misc.Misc;
import xaero.map.settings.ModOptions;
import xaero.map.world.MapDimension;

public class GuiCaveModeOptions {
    private MapDimension dimension;
    private boolean enabled;
    private GuiButton caveModeStartSlider;
    private GuiTextField caveModeStartField;
    private String caveModeStartFieldPlaceholder;

    public void onInit(final GuiMap screen) {
        this.caveModeStartSlider = null;
        this.caveModeStartField = null;
        this.dimension = screen.getDimension();
        if (this.enabled && this.dimension != null) {
            this.updateSlider(screen);
            this.updateField(screen);
            final CursorBox caveModeTypeButtonTooltip = new CursorBox("gui.xaero_wm_box_cave_mode_type");
            screen.addGuiButton(new TooltipButton(20, screen.field_146295_m - 62, 150, 20, this.getCaveModeTypeButtonMessage().func_150254_d(), new Supplier<CursorBox>(){

                @Override
                public CursorBox get() {
                    return caveModeTypeButtonTooltip;
                }
            }){

                @Override
                public void onPress() {
                    GuiCaveModeOptions.this.onCaveModeTypeButton(this, screen);
                }
            });
        }
        this.caveModeStartFieldPlaceholder = I18n.func_135052_a((String)"gui.xaero_wm_cave_mode_start_auto", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCaveModeTypeButton(GuiButton b, GuiMap screen) {
        this.dimension.toggleCaveModeType(true);
        Object object = screen.getMapProcessor().uiSync;
        synchronized (object) {
            this.dimension.saveConfigUnsynced();
        }
        b.field_146126_j = this.getCaveModeTypeButtonMessage().func_150254_d();
    }

    private GuiTextField createField(final GuiMap screen) {
        GuiTextField field = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, 172, screen.field_146295_m - 40, 50, 20);
        field.func_146203_f(7);
        field.func_146180_a(WorldMap.settings.caveModeStart == Integer.MAX_VALUE ? "" : WorldMap.settings.caveModeStart + "");
        field.func_175207_a(new GuiPageButtonList.GuiResponder(){

            public void func_175319_a(int id, String text) {
                try {
                    WorldMap.settings.caveModeStart = text.isEmpty() || text.equalsIgnoreCase("auto") ? Integer.MAX_VALUE : Integer.parseInt(text);
                    GuiCaveModeOptions.this.updateSlider(screen);
                    try {
                        WorldMap.settings.saveSettings();
                    }
                    catch (IOException e) {
                        WorldMap.LOGGER.error("suppressed error", (Throwable)e);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }

            public void func_175320_a(int id, float value) {
            }

            public void func_175321_a(int id, boolean value) {
            }
        });
        return field;
    }

    private GuiButton createSlider(GuiMap screen) {
        return new ModOptionSlider(ModOptions.CAVE_MODE_START, ModOptions.CAVE_MODE_START.returnEnumOrdinal(), 20, screen.field_146295_m - 40, 150, 20, screen.field_146294_l);
    }

    private void updateField(GuiMap screen) {
        this.caveModeStartField = this.createField(screen);
    }

    private void updateSlider(GuiMap screen) {
        if (this.caveModeStartSlider == null) {
            this.caveModeStartSlider = this.createSlider(screen);
            screen.addGuiButton(this.caveModeStartSlider);
        } else {
            this.caveModeStartSlider = this.createSlider(screen);
            screen.replaceWidget(this.caveModeStartSlider, this.caveModeStartSlider);
        }
    }

    public void toggle(GuiMap screen) {
        this.enabled = WorldMap.settings.isCaveMapsAllowed() && !this.enabled;
        screen.func_146280_a(Minecraft.func_71410_x(), screen.field_146294_l, screen.field_146295_m);
    }

    public void onCaveModeStartSet(GuiMap screen) {
        if (this.enabled) {
            this.updateField(screen);
        }
    }

    public void tick(GuiMap screen) {
        if (this.enabled) {
            this.caveModeStartField.func_146178_a();
        }
    }

    public void unfocusAll() {
        if (this.caveModeStartField != null) {
            this.caveModeStartField.func_146195_b(false);
        }
    }

    private ITextComponent getCaveModeTypeButtonMessage() {
        return new TextComponentString(I18n.func_135052_a((String)"gui.xaero_wm_cave_mode_type", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.dimension == null ? "N/A" : (this.dimension.getCaveModeType() == 0 ? "gui.xaero_off" : (this.dimension.getCaveModeType() == 1 ? "gui.xaero_wm_cave_mode_type_layered" : "gui.xaero_wm_cave_mode_type_full"))), (Object[])new Object[0]));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public GuiTextField getCaveModeStartField() {
        return this.caveModeStartField;
    }

    public void postMapRender(GuiMap gui, int scaledMouseX, int scaledMouseY, int width, int height, float partialTicks) {
        if (this.enabled) {
            boolean placeholder = this.caveModeStartField.func_146179_b().isEmpty();
            if (placeholder) {
                Misc.setFieldText(this.caveModeStartField, this.caveModeStartFieldPlaceholder, -11184811);
                this.caveModeStartField.func_146190_e(0);
            }
            this.caveModeStartField.func_146194_f();
            if (placeholder) {
                Misc.setFieldText(this.caveModeStartField, "");
            }
        }
    }
}

